;**********************************************
; Test read data form PCF8574AP Display to RS232 Boardrate 9600 8N1
; Hardware  : CP-PIC V3.0 & V4.0
; OSC       : 10 MHz [ HS mode ]
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 01/8/2002
;**********************************************

     LIST P=16f877
     include <p16f877.inc>

 __CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _WRT_ENABLE_ON & _LVP_OFF & _DEBUG_OFF & _CPD_OFF
         
#define   SDA     PORTC,4  
#define   SCL     PORTC,3

DT1       EQU       0x20
DT2       EQU       0x21
RD_BUF    EQU       0x22
WR_BUF    EQU       0x23
COUNT     EQU       0x24
DAT       EQU       0x25
B1        EQU       0x26
BB        EQU       0x27
       

;*********************************************
          ORG       0x0000
          
	  BSF	    STATUS,RP0     ; select bank 1
          BCF       TRISC,4
          BCF       TRISC,3
          MOVLW     0x40           ; BAUD rate 9600
          MOVWF     SPBRG
          CLRF      TXSTA          ; 8 bits data ,no,1 stop
          BSF       TXSTA,TXEN     ; Transmit enable
	  BSF	    TXSTA,BRGH     ; hi speed

	  BCF	    STATUS,RP0     ; select bank 0
          CLRF      RCSTA
          BSF       RCSTA,SPEN     ; Asynchronous serial port enable
          BSF       RCSTA,CREN     ; continuous receive
	  
NEW       MOVLW     0x0C           ; Clear display
          CALL      SEND
          MOVLW     "D"
          CALL      SEND
          MOVLW     "A"
          CALL      SEND
          MOVLW     "T"
          CALL      SEND
          MOVLW     "A"
          CALL      SEND
          MOVLW     " "
          CALL      SEND
          MOVLW     "I"
          CALL      SEND        
	  MOVLW     "N"
          CALL      SEND
          MOVLW     " "
          CALL      SEND
                           
          MOVLW     0xA             ; new line
          CALL      SEND
          MOVLW     0xD
          CALL      SEND
	  MOVLW     "="
          CALL      SEND
 	  MOVLW     " "
	  CALL      SEND

;*********** READ DATA FORM PCF8574AP *************
	  
          CALL	    START
          MOVLW     0x71           ; control byte
          CALL	    WR_I2C
	  MOVLW     0xff           ; WRITE BUFFER IS "11111111"
	  CALL      WR_I2C
	  CALL      STOP

	  CALL	    START
          MOVLW     0x71           ; control byte
          CALL	    WR_I2C
	  CALL	    RD_I2C         ; READ DATA FORM I2C BUS
	  MOVF      RD_BUF,w	   ; save data to w
	  
	  CALL      ADJT            ; display data	   
	  CALL	    STOP
	  CALL	    SDEL
	  GOTO	    NEW

;**********************************************************
; Convert time 1 byte to ASCII 2 bytes and send to display
; Input  : W
; Output : -
;**********************************************************
ADJT      MOVWF     BB             ; B1 = HHHH LLLL
          SWAPF     BB,W           ; W  = LLLL HHHH
	  CALL      CHECK           
          MOVF      BB,W
          CALL      CHECK
          RETURN

CHECK     ANDLW     0X0F	  
	  MOVWF     B1
	  CLRC                    ; CLEAR CARRY FLAG
	  SUBLW     0X0A
	  BZ        CC            ; = 0XA JUMP TO CC 
	  BC        CONV          ; < 0XA JUMP TO CONV
CC	  MOVF      B1,W          ; A - F
	  ADDLW     0X37
	  CALL      SEND           ; SEND FIRST DIGIT
	  RETURN
CONV      MOVF      B1,W          ; 0 - 9
          ADDLW     0X30
	  CALL      SEND	   ; SEND LAST DIGIT
          RETURN

;********************************************************
; Send data to RS-232 9600 Buad,8 bits data, No parity, 1 stop
; Input  : W
; Output : Computer screen
;********************************************************
SEND      MOVWF     TXREG          ; Send recent data to TX 
WAIT1     MOVLW     TXSTA
	  MOVWF	    FSR
          BTFSS     INDF,1         ; check TRMT bit in TXSTA register
	  GOTO      WAIT1          ; TXREG full  or TRMT = 0
          RETURN


;****************** WRITE DATA TO I2C BUS ************************

WR_I2C		MOVWF	WR_BUF     ; data to buffer
		MOVLW	.8	   ; loop counter = 8
		MOVWF	COUNT
		CALL	SCL_LOW
		CALL    DELAY
WR_LOOP	        RLF	WR_BUF,F   ; rotate data to buffer
		BC	SEND_1	   ; Branch to SEND_1 if carry = 1
SEND_0		CALL    SDA_LOW
		CALL	PULSE
		GOTO	CHK
SEND_1		CALL	SDA_HIGH
		CALL	PULSE
CHK		DECFSZ	COUNT,F
		GOTO	WR_LOOP
		CALL	SDA_HIGH
		CALL	RD_ACK
		RETURN 


;************************************
; Read data Form I2C Bus
;************************************
RD_I2C		MOVLW	.8		; counter = 8
		MOVWF	COUNT
		CLRF    RD_BUF		; clear read buffer
		CALL	SCL_LOW
		CALL	SDA_HIGH
RD_LOOP	        CALL	SCL_HIGH
		BTFSC	SDA
		GOTO	RD_1
RD_0		CLRC			; clear carry flag
		GOTO	ROTATE
RD_1		SETC			; set carry flag
ROTATE		RLF	RD_BUF,F	; rotate carry flag to buffer
		CALL	SCL_LOW
		DECFSZ	COUNT,F
		GOTO	RD_LOOP
		RETURN

;********  READ ACK **************
RD_ACK  	CALL	SDA_HIGH
		CALL	SCL_LOW
		CALL	SCL_HIGH
		BTFSC	SDA		; test bit SDA skip if = "0"
		GOTO	STOP		; stop 
		BTFSS	SCL		; test bit SCL skip if = "1"
		GOTO	$-1
	        CALL	SCL_LOW          
		CALL    DELAY
		RETURN

;******************************
; Start bit I2BUS
;******************************
START		CALL	SDA_HIGH        
		CALL	SCL_HIGH
		BTFSS	SCL
		GOTO	$-1
		BTFSS	SDA
		GOTO	$-1
		CALL	SDA_LOW
		CALL	SCL_LOW
		RETURN

;********  STOP *************
STOP		CALL	SCL_LOW
		CALL	SDA_LOW
		CALL	SCL_HIGH
		CALL	SDA_HIGH
		CALL	DELAY
		RETURN

;******** SCL PULSE *************** 
PULSE    	CALL	SCL_LOW
	        CALL    DELAY
		CALL	SCL_HIGH
	        CALL    DELAY
		CALL	SCL_LOW
		RETURN

;********** SCL HIGH ********************
SCL_HIGH
        	BANKSEL TRISC
		BSF	TRISC,3
		BANKSEL	PORTC
		RETURN

;******** SCL LOW **********************
SCL_LOW
		BANKSEL	TRISC
		BCF	TRISC,3
		BANKSEL	PORTC
		BCF	SCL
		RETURN

;******** SDA HIGH ********************
SDA_HIGH	
		BANKSEL	TRISC
		BSF	TRISC,4
		BANKSEL	PORTC
		RETURN

;********  SDA  LOW *****************
SDA_LOW		
		BANKSEL	TRISC
		BCF	TRISC,4
		BANKSEL	PORTC
		BCF	SDA
		RETURN
;******************************
; DELAY TIME
;******************************
DELAY     MOVLW	    .5
	  MOVWF	    DT1
	  DECFSZ    DT1,F
	  GOTO	    $-1
	  RETURN

SDEL      MOVLW     0x00
          MOVWF     DT1
SD2       MOVLW     0x00
          MOVWF     DT2
SD1       DECFSZ    DT2
          GOTO      SD1
          DECFSZ    DT1
          GOTO      SD2
          RETURN
	
	END
